require( "scripts/style.lua" );

SliderFont = {
  standardFont,
  18,
  BorderColor
};

TitleFont = {
  standardFont,
  30,
  BorderColor
};

CheckboxFont = {
  standardFont,
  18,
  BorderColor
};

ButtonFont = {
  standardFont,
  24,
  BorderColor
};


local bitmapType = PopThroughBitmap;
if (IsWindowOpen('scripts/game.lua')) then
	bitmapType = Bitmap;
end
MakeDialog
{
	bitmapType
	{
		name="pausebackground",
		image="backgrounds/popup",
		x = kCenter,
		y = kCenter,
		
		OptionsWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			
			Text
			{
				font = TitleFont,
				name = "title",
				x=kCenter,y=20,w=kMax,h=50,
				flags = kHAlignCenter + kVAlignTop,
				label = "options"
			};
			
			
			Text
			{
				font = SliderFont,
				name = "sfx",
				x=30,y=35,w=100,h=60,
				flags = kHAlignCenter + kVAlignCenter,
				label = "sfxlevel"
			};
		
			SetStyle(SliderStyle);
			Slider
			{
				name="sfxlevelslider",
				x = 140,
				y = 55,
				w = 265,
				hslider = true,
			};
			SetStyle(DefaultStyle);
			
			Text
			{
				font = SliderFont,
				name = "music",
				x=30,y=75,w=100,h=60,
				flags = kHAlignCenter + kVAlignCenter,
				label = "musiclevel"
			};
			
			SetStyle(SliderStyle);
			Slider
			{
				name="musiclevelslider",
				x = 140,
				y = 95,
				w = 265,
				hslider = true,
			};
			

			SetStyle(DefaultStyle);
			
			
			
			Button{
				graphics = CheckboxButtonGraphics,
				name="fullscreen",
				type = kToggle,
				x=50,
				y=115,
				w=150,
				Text
				{
					font = CheckboxFont,
					name = "fullscreenlabel",
					x=50,
					y=25,
					w=kMax,
					h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label="fullscreen",
				};
				command=
				function()
					beforeValue = IsFullScreen();
					DebugOut( "beforeValue = " .. tostring(beforeValue));
					if (ToggleFullScreen() == false) then
						
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="screenswitchfailed",
							title = "" 
						};
					end
					afterValue = IsFullScreen();
					DebugOut("afterValue = " .. tostring(afterValue));
					if (beforeValue == afterValue) then
						SetButtonToggleState("fullscreen", afterValue);
					end				
				end
				
			};
			
			Button{
				graphics = CheckboxButtonGraphics,
				name="mutebox",
				type = kToggle,
				x=225,
				y=115,
				w=225,
				Text
				{
					font = CheckboxFont,
					name = "mutesoundlabel",
					x=50,
					y=25,
					w=kMax,
					h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label="mutesound",
				};
				command =
					function()
						ToggleSoundMute();
					end
			};
			
			SetStyle(SmallButtonStyle);
			Button
			{
				x=75,
				y=175,
				name="credits",
				label="credits",
				command =
					function()
						DoFullScreenPopThrough(true);
						DoModal("scripts/credits.lua");
						DoFullScreenPopThrough(false);
					end
			},
			
			Button
			{
				x=75,
				y=215,
				name="help",
				label="help",
				command =
					function()
						DoFullScreenPopThrough(true);
						DoModal("scripts/help1.lua");
						DoFullScreenPopThrough(false);
					end
			},
			
			Button
			{
				x=250,
				y=175,
				name="highscores",
				label="highscores",
				command =
					function()
						DoFullScreenPopThrough(true);
						DoModal("scripts/hiscore.lua");
						DoFullScreenPopThrough(false);
					end
			},
			
			Button
			{
				x=250,
				y=215,
				name="back",
				label="ok",
				command =
					function()
						SaveVolumes();
						PopModal("scripts/options.lua");
					end
			},
			SetStyle(DefaultStyle);
		},
	},
}

if (IsWindowOpen('scripts/game.lua')) then
	EnableWindow('highscores', false);
	EnableWindow('credits', false);
end
